DECLARE @Versao VARCHAR(4)

SET @Versao = CASE 
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '15' THEN '2019'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '14' THEN '2017'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '13' THEN '2016'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '12' THEN '2014'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '11' THEN '2012'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '10' THEN '2008'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '09' THEN '2005'
                 ELSE '2000'
              END
			  
IF CONVERT(INT,@Versao) >= 2012
BEGIN

	/*Criação de tabela BASE para migração*/
	IF NOT EXISTS (SELECT 1
				   FROM   sys.objects
				   WHERE  object_id = Object_id(N'DBO.EST_NF_ENT_ENTRADA_ICMS_ST_MOV_MIGRACAO'))
	BEGIN

			CREATE TABLE [dbo].[EST_NF_ENT_ENTRADA_ICMS_ST_MOV_MIGRACAO](
																		[PROT_ICMS_ST] [bigint] NOT NULL,
																		[CD_EMP] [int] NOT NULL,
																		[CD_FILIAL] [int] NOT NULL,
																		[CD_NF_ENT_CRED] [int] NOT NULL,
																		[TIPO_DOC] [int] NOT NULL,
																		[CD_DOC] [int] NOT NULL,
																		[CD_PROD] [int] NULL,
																		[QT_IT] [int] NULL,
																		[VLR_ICMS_ST_DARE] [money] NULL,
																		[VLR_ICMS_EFETIVO] [money] NULL,
																		[VLR_ICMS_SUBS] [money] NULL,
																		[VLR_ICMS_RET] [money] NULL,
																		[VLR_FECOP] [money] NULL,
																		[VLR_FECOP_RET] [money] NULL,
																		[VLR_FECOP_ST] [money] NULL,
																		[STATUS] [int] NULL,
																		[PROT_ICMS_ST_SAIDA] [bigint] NULL,
																		[DT_CAD] [datetime] NULL,
																		[CD_IT] [int] NULL)


			
	END


	/*Alimentando dados da tabela de migração*/
	INSERT INTO [EST_NF_ENT_ENTRADA_ICMS_ST_MOV_MIGRACAO]
	SELECT PROT_ICMS_ST
			,CD_EMP
			,CD_FILIAL
			,CD_NF_ENT_CRED
			,TIPO_DOC
			,CD_DOC
			,CD_PROD
			,QT_IT
			,VLR_ICMS_ST_DARE
			,VLR_ICMS_EFETIVO
			,VLR_ICMS_SUBS
			,VLR_ICMS_RET
			,VLR_FECOP
			,VLR_FECOP_RET
			,VLR_FECOP_ST
			,STATUS
			,PROT_ICMS_ST_SAIDA
			,DT_CAD
			,CD_IT
	FROM [EST_NF_ENT_ENTRADA_ICMS_ST_MOV] MOV
	WHERE NOT EXISTS (SELECT 1 FROM [EST_NF_ENT_ENTRADA_ICMS_ST_MOV_MIGRACAO] M
						WHERE M.PROT_ICMS_ST = MOV.PROT_ICMS_ST)


	/*Recriando tabela original com a estrutura correta*/
	IF  EXISTS (SELECT 1 
				FROM sys.objects 
				WHERE object_id = OBJECT_ID(N'EST_NF_ENT_ENTRADA_ICMS_ST_MOV') 
				AND type in (N'U'))
	BEGIN
		DROP TABLE [dbo].[EST_NF_ENT_ENTRADA_ICMS_ST_MOV]
	END


	CREATE TABLE [dbo].[EST_NF_ENT_ENTRADA_ICMS_ST_MOV](
	[CD_EST_NF_ENT_ENTRADA_ICMS_ST_MOV] [bigint] IDENTITY(1,1) NOT NULL,
	[PROT_ICMS_ST] [bigint] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF_ENT_CRED] [int] NOT NULL,
	[TIPO_DOC] [int] NOT NULL,
	[CD_DOC] [int] NOT NULL,
	[CD_PROD] [int] NULL,
	[QT_IT] [int] NULL,
	[VLR_ICMS_ST_DARE] [money] NULL,
	[VLR_ICMS_EFETIVO] [money] NULL,
	[VLR_ICMS_SUBS] [money] NULL,
	[VLR_ICMS_RET] [money] NULL,
	[VLR_FECOP] [money] NULL,
	[VLR_FECOP_RET] [money] NULL,
	[VLR_FECOP_ST] [money] NULL,
	[STATUS] [int] NULL,
	[PROT_ICMS_ST_SAIDA] [bigint] NULL,
	[DT_CAD] [datetime] NULL,
	[CD_IT] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[CD_EST_NF_ENT_ENTRADA_ICMS_ST_MOV] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
end


	/*Populando novamente a tabela oficial*/

	INSERT INTO [EST_NF_ENT_ENTRADA_ICMS_ST_MOV]
		SELECT PROT_ICMS_ST
				,CD_EMP
				,CD_FILIAL
				,CD_NF_ENT_CRED
				,TIPO_DOC
				,CD_DOC
				,CD_PROD
				,QT_IT
				,VLR_ICMS_ST_DARE
				,VLR_ICMS_EFETIVO
				,VLR_ICMS_SUBS
				,VLR_ICMS_RET
				,VLR_FECOP
				,VLR_FECOP_RET
				,VLR_FECOP_ST
				,STATUS
				,PROT_ICMS_ST_SAIDA
				,DT_CAD
				,CD_IT
	FROM [EST_NF_ENT_ENTRADA_ICMS_ST_MOV_MIGRACAO] M
	WHERE NOT EXISTS (SELECT 1 FROM [EST_NF_ENT_ENTRADA_ICMS_ST_MOV] MOV
						WHERE M.PROT_ICMS_ST = MOV.PROT_ICMS_ST)


	/*Criação de indices auxiliares*/

	IF EXISTS (
			SELECT *
			FROM sys.indexes
			WHERE object_id = OBJECT_ID(N'EST_NF_ENT_ENTRADA_ICMS_ST_MOV')
				AND name = N'IX_EST_NF_ENT_ENTRADA_ICMS_ST_MOV_PROT_ICMS_ST'
			)
	BEGIN
		DROP INDEX IX_EST_NF_ENT_ENTRADA_ICMS_ST_MOV_PROT_ICMS_ST ON EST_NF_ENT_ENTRADA_ICMS_ST_MOV
	END
	GO

	IF EXISTS (
			SELECT *
			FROM sys.indexes
			WHERE object_id = OBJECT_ID(N'EST_NF_ENT_ENTRADA_ICMS_ST_MOV')
				AND name = N'IX_EST_NF_ENT_ENTRADA_ICMS_ST_MOV_DELETE_RESERVA'
			)
	BEGIN
		DROP INDEX IX_EST_NF_ENT_ENTRADA_ICMS_ST_MOV_DELETE_RESERVA ON EST_NF_ENT_ENTRADA_ICMS_ST_MOV
	END
	GO

	CREATE NONCLUSTERED INDEX IX_EST_NF_ENT_ENTRADA_ICMS_ST_MOV_PROT_ICMS_ST ON EST_NF_ENT_ENTRADA_ICMS_ST_MOV (PROT_ICMS_ST)

	CREATE NONCLUSTERED INDEX IX_EST_NF_ENT_ENTRADA_ICMS_ST_MOV_DELETE_RESERVA ON EST_NF_ENT_ENTRADA_ICMS_ST_MOV (CD_EMP
	,CD_FILIAL
	,CD_DOC
	,CD_PROD
	,CD_IT)
